/*-
 * Copyright (c) 2004 - 2011 CTPP Team
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the CTPP Team nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      FnHashElement.hpp
 *
 * $CTPP$
 */
#ifndef _VM_FN_HASH_ELEMENT_HPP__
#define _VM_FN_HASH_ELEMENT_HPP__ 1

#include "CTPP2VMSyscall.hpp"

/**
  @file FnHashElement.hpp
  @brief Virtual machine standard library function, get hash element
*/

namespace CTPP // C++ Template Engine
{

class CDT;
class Logger;

/**
  @class FnHashElement FnHashElement.hpp <FnHashElement.hpp>
  @brief Get element of array
*/
class FnHashElement:
  public SyscallHandler
{
	/**
	  @brief A destructor
	*/
	~FnHashElement() throw();

private:
	friend class STDLibInitializer;

	// ///////////////////////////////////////////////////////////////

	/**
	  @brief Constructor
	*/
	FnHashElement();

	/**
	  @brief Copy constructor
	  @param oRhs - object to copy
	*/
	FnHashElement(const FnHashElement & oRhs);

	/**
	  @brief Copy operator =
	  @param oRhs - object to copy
	*/
	FnHashElement & operator =(const FnHashElement & oRhs);

	/**
	  @brief Handler
	  @param aArguments - list of arguments
	  @param iArgNum - number of arguments
	  @param oCDTRetVal - return value
	*/
	INT_32 Handler(CDT            * aArguments,
	               const UINT_32    iArgNum,
	               CDT            & oCDTRetVal,
	               Logger         & oLogger);

	/**
	  @brief Get function name
	*/
	virtual CCHAR_P GetName() const;
};

} // namespace CTPP
#endif // _VM_FN_HASH_ELEMENT_HPP__
// End.
